var menu_arr = [{
  "title": "컬럼 유형과 기능",
  "child": [{
    "title": "컬럼 별 타입",
    "url": "type.js",
    "hash": "type,타입",
    "mark": "Type"
  }, {
    "title": "숫자, 날짜 포맷",
    "url": "format.js",
    "hash": "format,포맷",
    "mark": "Format,Extend,EditFormat,DataFormat"
  }, {
    "title": "Enum형 컬럼",
    "url": "autoComplete.js",
    "hash": "자동완성,autoComplete",
    "mark": "Suggest"
  }, {
    "title": "관계형 콤보",
    "url": "relationCombo.js",
    "hash": "enum,combo,Relation,관계형",
    "mark": "Enum,EnumKeys,Related"
  }, {
    "title": "라디오 그룹",
    "url": "radio.js",
    "hash": "radio",
    "mark": "Radio"
  }, {
    "title": "HTML 타입 컬럼",
    "url": "htmlType.js",
    "hash": "htmlType"
  }, {
    "title": "File 타입 컬럼",
    "url": "fileType.js",
    "hash": "fileType"
  }
]
}, {
  "title": "행고정,열고정",
  "child": [{
    "title": "열고정",
    "url": "section.js",
    "hash": "frozen,틀고정,열고정",
    "mark": "LeftCols,RightCols,Cols,SectionCanResize"
  }, {
    "title": "행고정",
    "url": "header.js",
    "hash": "상단,하단,행고정",
    "mark": "Foot,Head,Kind"
  }, {
    "title": "Solid(커스텀행)",
    "url": "solid.js",
    "hash": "커스텀행,solid",
    "mark": "Solid,Cells,Space"
  }]
}, {
  "title": "포커스 이동",
  "url": "focus.js",
  "hash": "포커스,focus",
  "mark": "CanFocus"
}, {
  "title": "숫자 연산",
  "child": [{
    "title": "합계",
    "url": "sum.js",
    "hash": "합계,total,sum",
    "mark": "FormulaRow"
  }, {
    "title": "소계 기능",
    "url": "subTotal.js",
    "hash": "소계,subtotal",
    "mark": "makeSubTotal"
  }, {
    "title": "열계산식",
    "url": "formulaCol.js",
    "hash": "열계산,포뮬러",
    "mark": "Formula,CanFormula"
  }, {
    "title": "피벗",
    "url": "pivot.js",
    "hash": "피봇,피벗,pivot",
    "mark": "createPivotDialog"
  }]
}, {
  "title": "속성 포뮬러",
  "child":[
    {
      "title": "포뮬러 예제1",
      "url": "formula.js",
      "hash": "formula,포뮬라",
      "mark": "CanFormula,CalcOrder,CanEditFormula,TextColorFormula,ColorFormula,IconFormula,HtmlPrefixFormula,ClassFormula"
    },
    {
      "title": "포뮬러 예제2",
      "url": "formula2.js",
      "hash": "formula,포뮬라,attribute",
      "mark": "CanFormula,CalcOrder,CanEditFormula,TextColorFormula,ColorFormula,IconFormula,HtmlPrefixFormula,ClassFormula"
    }
  ]
}, {
  "title": "데이터 조회",
  "child": [
    {
      "title": "렌더링 방식",
      "url": "render.js",
      "hash": "rendering,FastLoad,LazyLoad",
      "mark": "SearchMode,FastLoad,LazyLoad"
    }, {
      "title": "페이징",
      "url": "paging.js",
      "hash": "페이징,조회,callback",
      "mark": "SearchMode,PageLength,doSearch,doSearchPaging"
    }, {
      "title": "대용량 데이터 조회",
      "url": "massDataLoad.js",
      "hash": "대량,대용량,bigdata",
      "mark": "SearchMode"
    }, {
      "title": "행 높이 자동 맞춤",
      "url": "autoRowHeight.js",
      "hash": "행높이,자동맞춤,AutoRowHeight",
      "mark": "AutoRowHeight"
    }
  ]
}, {
  "title": "데이터 저장",
  "child": [{
    "title": "기본 저장",
    "url": "save.js",
    "hash": "저장,save",
    "mark": "doSave,getSaveString,getSaveJson,Required"
  }, {
    "title": "유효성검증,콜백",
    "url": "validation.js",
    "hash": "validation,callback",
    "mark": "Required,onSave,onAfterSave,doSave"
  }]
}, {
  "title": "편집",
  "child": [{
    "title": "정규식(RegExp)를 이용한 검증",
    "url": "regexp.js",
    "hash": "편집,정규식,regexp",
    "mark": "ResultText,EditMask,ResultMask,ResultMessage,ResultMessageTime,onResultMask"
  }, {
    "title": "편집 다이얼로그",
    "url": "dialog.js",
    "hash": "dialog",
    "mark": "EditMaskFunc,CustomFormat,setValue,setString,getValue,getString,showEditDialog"
  }, {
    "title": "영역 선택",
    "url": "select.js",
    "hash": "select,선택",
    "mark": "CanSelect,selectRange,getSelectedRanges,clearSelection"
  }, {
    "title": "Copy & Paste",
    "url": "copypaste.js",
    "hash": "copy,paste,복사,붙여넣기",
    "mark": "PasteFocused,PasteCols"
  }]
}, {
  "title": "머지",
  "child": [{
    "title": "자동 머지",
    "url": "merge.js",
    "hash": "merge,머지,span",
    "mark": "HeaderMerge,DataMerge,setAutoMerge,PrevColumnMerge"
  }, {
    "title": "머지영역지정",
    "url": "mergeRange.js",
    "hash": "merge,머지,span",
    "mark": "setMergeRange,setMergeCancel"
  }]
}, {
  "title": "헤더기능",
  "child": [{
    "title": "소팅",
    "url": "sort.js",
    "hash": "소팅,sort,정렬",
    "mark": "CanSort,MaxSort,RawSort,NumberSort,SortPos,SortValue"
  }, {
    "title": "필터",
    "url": "filter.js",
    "hash": "필터,filter,검색",
    "mark": "showFilterRow,ShowFilter,hideFilterRow"
  }, {
    "title": "그룹핑",
    "url": "group.js",
    "hash": "group,그룹",
    "mark": "Solid,GroupMain,GroupFormat,Kind,GroupDef,GroupSole,GroupDeleted,CanGroup,GroupWidth,onBeforeGroup,conAfterGroup"
  }, {
    "title": "찾기",
    "url": "find.js",
    "hash": "찾기,find,search,검색",
    "mark": "Solid,Kind,showFindDialog"
  }]
}, {
  "title": "트리",
  "url": "tree.js",
  "hash": "tree,트리",
  "mark": "MainCol,Items,getNextSiblingRow,showTreeLevel"
}, {
  "title": "파일 import/export",
  "child": [{
    "title": "파일 Export",
    "url": "file-export.js",
    "hash": "down,엑셀,text",
    "mark": "Export,Url,down2Excel,down2Text,showExcelDownloadDialog,onExportFinish"
  }, {
    "title": "파일 Import",
    "url": "file-import.js",
    "hash": "upload,엑셀",
    "mark": "Export,Url,loadExcel,loadText,onImportFinish"
  }, {
    "title": "인쇄",
    "url": "print.js",
    "hash": "인쇄,print",
    "mark": "doPrint"
  }]
}, {
  "title": "컨택스트 메뉴",
  "url": "context-menu.js",
  "hash": "context,메뉴,menu",
  "mark": "Menu,Items,Level,Expanded,Columns,onSelectMenu,showMenu"
}, {
  "title": "이벤트",
  "url": "events.js",
  "hash": "이벤트,event"
}, {
  "title": "메시지",
  "url": "message.js",
  "hash": "메시지",
  "mark": "SuppressMessage,hideMessage,showMessage,showMessageTime"
}, {
  "title": "멀티레코드",
  "child": [{
    "title": "멀티 레코드(쇼핑몰)",
    "url": "multirecord_goods.js",
    "hash": "멀티,레코드,다중라인,쇼핑몰,상품",
    "mark": "MultiRecord,RecordRowSpan,RecordColSpan,Cols"
  }, {
    "title": "멀티 레코드(인사정보)",
    "url": "multirecord_rh.js",
    "hash": "멀티,레코드,다중라인,인사정보",
    "mark": "MultiRecord,RecordRowSpan,RecordColSpan,Cols"
  }, {
    "title": "멀티 레코드(도서관정보)",
    "url": "multirecord_lb.js",
    "hash": "멀티,레코드,다중라인,도서관정보",
    "mark": "MultiRecord,RecordRowSpan,RecordColSpan,RecordHColSpan,RecordHColTitle,Cols"
  }, {
    "title": "멀티 레코드(학교위치)",
    "url": "multirecord_school_location.js",
    "hash": "멀티,레코드,다중라인,학교위치",
    "mark": "MultiRecord,RecordRowSpan,RecordColSpan,RecordHColSpan,RecordHColTitle,Cols"
  }]
}, {
  "title": "기타 기능",
  "child": [{
    "title": "툴팁",
    "url": "tooltip.js",
    "hash": "tooltip,툴팁,풍선도움말",
    "mark": "Tip,ShowHint,onShowHint,onShowTip"
  }, {
    "title": "Drag & Drop",
    "url": "dragdrop.js",
    "hash": "드래그,드롭,drag,drop",
    "mark": "CanDrag,onStartDrag,onEndDrag,onAfterRowMoveToSheet"
  }, {
    "title": "셀 Drag & Drop",
    "url": "celldrag.js",
    "hash": "드래그,드롭,celldrag,drag,drop",
    "mark": "CanDrag,DragCell,onStartDragCell,onEndDragCell"
  }, {
    "title": "달력",
    "url": "calendar.js",
    "hash": "calendar,달력",
    "mark": "dateToString,showCalendar,OnCanEditDate,OnGetCalendarDate,onReadCanEditDate,Range,Buttons,Texts"
  }, {
    "title": "개인화",
    "url": "custom.js",
    "hash": "개인화,컬럼정보",
    "mark": "StorageSession,StorageKeyPrefix,saveCurrentInfo,clearCurrentInfo,Menu"
  }, {
    "title": "필수 입력 항목",
    "url": "required.js",
    "hash": "필수,입력,항목",
    "mark": "Required"
  }, {
    "title": "MathJax 연동 예제",
    "url": "mathjax.js",
    "hash": "mathjax,MathJax,외부라이브러리,연동,라이브러리",
    "mark": "MathJax,onBeforeChange,onSearchFinish"
  },{
    "title": "테마 예제",
    "url": "theme.js",
    "hash": "setTheme,테마",
    "mark": "setTheme"
  },{
    "title": "Master/Detail",
    "url": "masterDetail.js",
    "hash": "master,detail,마스터,디테일",
    "mark": "onBeforeFocus,onFocus,getSaveJson,ajax,loadSearchData"
  },{
    "title": "모바일 환경 예제",
    "url": "mobile.js",
    "hash": "mobile",
    "mark": "HideMobile"
  }]
}];

var getMenuList = function (keyStr) {
  if (keyStr) {
    var newArr = [];
    for (var i = 0; i < menu_arr.length; i++) {
      var item = menu_arr[i];
      if (item["child"]) {
        for (var x = 0; x < item["child"].length; x++) {
          if (item["child"][x]["hash"] && (item["child"][x]["hash"].toUpperCase()).indexOf(keyStr.toUpperCase()) > -1) {
            var t_item = {};
            // 이미 부모가 있나?
            var parent = newArr.filter(function(it){return it.title==item.title});
            if(parent.length>0){
              parent[0].child.push({
                "title": item["child"][x]["title"],
                "url": item["child"][x]["url"],
                "hash": item["child"][x]["hash"],
                "mark": item["child"][x]["mark"],
              });
            }else{
              //없으면 부모를 생성
              t_item["title"] = item["title"];
              t_item["child"] = [];
              t_item.child.push({
                "title": item["child"][x]["title"],
                "url": item["child"][x]["url"],
                "hash": item["child"][x]["hash"],
                "mark": item["child"][x]["mark"],
              });
              newArr.push(t_item);
            }



          }
        }
      } else {
        if (item["hash"] && (item["hash"].toUpperCase()).indexOf(keyStr.toUpperCase()) > -1) {
          newArr.push({
            "title": item["title"],
            "url": item["url"],
            "hash": item["hash"]
          });
        }
      }
    }
    return getMenuStr(newArr);
  } else {
    return getMenuStr(menu_arr);
  }
};

var getMenuStr = function (arr) {
  var menu_str = '<header class="major"><h2>IBSheet8 Samples</h2></header><ul class="navi">';
  var firstNode = 1;
  for (var i = 0; i < arr.length; i++) {
    var item = arr[i];
    if (item["child"]) {
      // if (firstNode) {
      //   menu_str += '<li><span class="opener active">' + item["title"] + '</span><ul>';
      //   firstNode = 0;
      // } else {
      menu_str += '<li><span  class="opener">' + item["title"] + '</span><ul>';
      // }

      for (var x = 0; x < item["child"].length; x++) {
        menu_str += "<li><a href='#' onclick='moveSamplePage(this,\"" + item["child"][x]["url"] + "\")'>" + item["child"][x]["title"] + "</a></li>";
      }
      menu_str += "</ul></li>";
    } else {
      menu_str += "<li><a href='#' onclick='moveSamplePage(this,\"" + item["url"] + "\")'>" + item["title"] + "</a></li>";
    }
  }
  menu_str += "</ul>";
  return menu_str;
};

var searchWork = function () {
  var obj = document.querySelector("#query");
  event.preventDefault();
  var findStr = obj.value;

  if (findStr == "") {
    $('nav#menu').html(getMenuList());
  }else{
    $('nav#menu').html(getMenuList(findStr));
    $('#menu > ul > li > span').each(function(item){
      $(this).toggleClass('active');
    });
  }

  $('#menu > ul > li > span').click(function() {
		$(this).toggleClass('active');
	});

};

var moveSamplePage = function (liObj, url) {
  var parentMenu = "";

  //대분류 메뉴명
  if (liObj.parentNode.parentNode.className != "navi") {
    if (liObj.parentNode.parentNode.className === "main-top") {
      var parentName = "";
      for (var i = 0; i < menu_arr.length; i++) {
        for (var j = 0; j < menu_arr[i].child.length; j++) {
          if (menu_arr[i].child[j] && menu_arr[i].child[j].url === url) {
            parentName = (menu_arr[i].title || "");
            i = menu_arr.length;
            break;
          }
        }
      }
      parentMenu = parentName;
    } else {
      parentMenu = liObj.parentNode.parentNode.previousElementSibling.textContent;
    }
  } else {
    parentMenu = liObj.textContent
  }

  if (!document.getElementById("sampleContents")) {
    //contents 이하 부분을 다시 만든다.
    $("#container").html('<div id="contents" style="height:100%"></div>');
  }
  if (parentMenu !== "") movePage(url, parentMenu);
};

$(document).ready(function () {
  $('nav#menu').html(getMenuList());

  $('.collapse').click(function(){
    $('#menu ul > li > span').each(function(item){
      $(this).removeClass('active');
    });
  });
  $('.expand').click(function(){
    $('#menu ul > li > span').each(function(item){
      $(this).addClass('active');
    });
  });

});
